//
//  MCDatabaseSyncDaemon.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-09.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCPGDaemon.h>


#define SyncDaemon ((MCDatabaseSyncDaemon *)[MCDaemon daemon])


@class MCClientStage, MCPDataStore, MCPModel, MCPDatabaseConnection, MCServerKeychain;

@interface MCDatabaseSyncDaemon : MCPGDaemon {

	MCServerKeychain *keychain;

	MCPModel *model;
	MCPModel *clientModel;
}

@property (retain) MCServerKeychain *keychain;

@property (nonatomic, retain) MCPModel *model;
@property (nonatomic, retain) MCPModel *clientModel;

// App-specific subclass methods to be overridden
- (BOOL)setApplicationUser:(NSString *)username forServer:(MCPDataStore *)server;

// For Touch and Staged subclasses
- (void)configureSyncDefaultsForClientStage:(MCClientStage *)stage;
- (MCPDatabaseObjectContext *)newServerContextWithConnection:(MCPDatabaseConnection *)conn;

@end
